<?php $__env->startSection('title', 'Detalles del Equipo'); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card shadow-sm">
            <div class="card-header bg-info text-white">
                <h5><i class="bi bi-pc-display"></i> Detalles del Equipo: <?php echo e($equipo->nombre_dispositivo); ?></h5>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <tr><th>Nombre</th><td><?php echo e($equipo->nombre_dispositivo); ?></td></tr>
                    <tr><th>Número de Serie</th><td><?php echo e($equipo->numero_serie ?? 'N/A'); ?></td></tr>
                    <tr><th>Dirección IP</th><td><?php echo e($equipo->direccion_ip ?? 'N/A'); ?></td></tr>
                    <tr><th>Oficina</th>
                        <td>
                            <?php echo e(optional($equipo->oficina)->nombre_oficina ?? 'N/A'); ?> 
                            (<?php echo e(optional($equipo->oficina?->agencia)->nombre_agencia ?? 'N/A'); ?>)
                        </td>
                    </tr>
                    <tr><th>Tipo de Equipo</th><td><?php echo e(optional($equipo->tipo)->nombre_tipo ?? 'N/A'); ?></td></tr>
                    <tr><th>Modelo</th>
                        <td>
                            <?php echo e(optional($equipo->modelo)->nombre_modelo ?? 'N/A'); ?> 
                            (<?php echo e(optional($equipo->modelo?->marca)->nombre_marca ?? 'N/A'); ?>)
                        </td>
                    </tr>
                    <tr><th>Hardware</th>
                        <td>
                            <?php if($equipo->hardware): ?>
                                <?php echo e($equipo->hardware->procesador); ?> | 
                                <?php echo e($equipo->hardware->ram_gb); ?>GB RAM | 
                                <?php echo e($equipo->hardware->almacenamiento_gb); ?>GB <?php echo e($equipo->hardware->tipo_almacenamiento); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr><th>Sistema Operativo</th>
                        <td>
                            <?php if($equipo->sistemaOperativo): ?>
                                <?php echo e($equipo->sistemaOperativo->nombre_so); ?> 
                                <?php echo e($equipo->sistemaOperativo->edicion); ?> 
                                (<?php echo e($equipo->sistemaOperativo->version); ?>)
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr><th>Responsable</th><td><?php echo e(optional($equipo->responsable)->nombre_responsable ?? 'N/A'); ?></td></tr>
                    <tr><th>Estado</th>
                        <td>
                            <span class="badge bg-<?php echo e($equipo->estado_equipo == 'Activo' ? 'success' : ($equipo->estado_equipo == 'Inactivo' ? 'warning' : 'danger')); ?>">
                                <?php echo e($equipo->estado_equipo); ?>

                            </span>
                        </td>
                    </tr>
                    <tr><th>Fecha Adquisición</th><td><?php echo e($equipo->fecha_adquisicion?->format('d/m/Y') ?? 'N/A'); ?></td></tr>
                    <tr><th>Último Mantenimiento</th><td><?php echo e($equipo->fecha_mantenimiento?->format('d/m/Y') ?? 'N/A'); ?></td></tr>
                    <tr><th>Depreciación Anual</th><td><?php echo e($equipo->depreciacion_anual ?? 'N/A'); ?>%</td></tr>
                    <tr><th>Antivirus</th><td><?php echo e($equipo->antivirus ?? 'N/A'); ?></td></tr>
                    <tr><th>VPN Cusco</th><td><?php echo e($equipo->vpn_cusco); ?></td></tr>
                    <tr><th>VPN Abancay</th><td><?php echo e($equipo->vpn_abancay); ?></td></tr>
                    <tr><th>Programas Instalados</th><td><pre class="bg-light p-2 rounded"><?php echo e($equipo->programas_instalados ?? 'N/A'); ?></pre></td></tr>
                    <tr><th>Licencias</th><td><pre class="bg-light p-2 rounded"><?php echo e($equipo->licencias ?? 'N/A'); ?></pre></td></tr>
                    <tr><th>Copias de Seguridad</th><td><pre class="bg-light p-2 rounded"><?php echo e($equipo->copias_seguridad ?? 'N/A'); ?></pre></td></tr>
                    <tr><th>Observaciones</th><td><pre class="bg-light p-2 rounded"><?php echo e($equipo->observacion ?? 'N/A'); ?></pre></td></tr>
                </table>

                <div class="d-flex justify-content-end">
                    <a href="<?php echo e(route('equipos.edit', $equipo)); ?>" class="btn btn-warning me-2">Editar</a>
                    <a href="<?php echo e(route('equipos.index')); ?>" class="btn btn-secondary">Volver</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Andespc\resources\views/admin/equipos/show.blade.php ENDPATH**/ ?>