<?php $__env->startSection('title', 'Editar Configuración de Hardware'); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-9">
        <div class="card shadow-sm">
            <div class="card-header bg-warning text-dark">
                <h5><i class="bi bi-pencil-square"></i> Editar Configuración de Hardware</h5>
            </div>
            <div class="card-body">

                
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('hardwares.update', $hardware)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="procesador" class="form-label">Procesador</label>
                            <input type="text" name="procesador" id="procesador" class="form-control"
                                value="<?php echo e(old('procesador', $hardware->procesador)); ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="ram_gb" class="form-label">RAM (GB) *</label>
                            <input type="number" name="ram_gb" id="ram_gb" class="form-control" required
                                value="<?php echo e(old('ram_gb', $hardware->ram_gb)); ?>">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="almacenamiento_gb" class="form-label">Almacenamiento (GB) *</label>
                            <input type="number" name="almacenamiento_gb" id="almacenamiento_gb" class="form-control" required
                                value="<?php echo e(old('almacenamiento_gb', $hardware->almacenamiento_gb)); ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="tipo_almacenamiento" class="form-label">Tipo de Almacenamiento *</label>
                            <select name="tipo_almacenamiento" id="tipo_almacenamiento" class="form-select" required>
                                <option value="">Seleccionar tipo</option>
                                <option value="HDD" <?php echo e(old('tipo_almacenamiento', $hardware->tipo_almacenamiento) == 'HDD' ? 'selected' : ''); ?>>HDD</option>
                                <option value="SSD" <?php echo e(old('tipo_almacenamiento', $hardware->tipo_almacenamiento) == 'SSD' ? 'selected' : ''); ?>>SSD</option>
                                <option value="NVMe" <?php echo e(old('tipo_almacenamiento', $hardware->tipo_almacenamiento) == 'NVMe' ? 'selected' : ''); ?>>NVMe</option>
                            </select>
                        </div>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?php echo e(route('hardwares.index')); ?>" class="btn btn-secondary me-md-2">Cancelar</a>
                        <button type="submit" class="btn btn-warning">Actualizar Hardware</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Andespc\resources\views/admin/hardwares/edit.blade.php ENDPATH**/ ?>